<?php
require 'conexao.php';
$notas = $pdo->query("SELECT n.*, c.nome AS cliente, s.nome AS servico FROM notas_recebimento n JOIN clientes c ON c.id = n.cliente_id JOIN servicos s ON s.id = n.servico_id ORDER BY n.data_emissao DESC")
               ->fetchAll(PDO::FETCH_ASSOC);
?>
<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <title>Notas Emitidas</title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css">
</head>
<body class="container py-4">
<h2>Notas Emitidas</h2>
<table class="table table-bordered">
    <thead>
        <tr><th>Cliente</th><th>Serviço</th><th>Valor</th><th>Vencimento</th><th>Forma Pagamento</th><th>Status</th><th>Emissão</th><th>Ações</th></tr>
    </thead>
    <tbody>
        <?php foreach ($notas as $n): ?>
            <tr>
                <td><?= $n['cliente'] ?></td>
                <td><?= $n['servico'] ?></td>
                <td>R$ <?= number_format($n['valor'], 2, ',', '.') ?></td>
                <td><?= date('d/m/Y', strtotime($n['vencimento'])) ?></td>
                <td><?= $n['forma_pagamento'] ?></td>
                <td><?= ucfirst($n['status']) ?></td>
                <td><?= date('d/m/Y H:i', strtotime($n['data_emissao'])) ?></td>
                <td><a href="recibo.php?id=<?= $n['id'] ?>" class="btn btn-sm btn-secondary" target="_blank">Imprimir</a></td>
            </tr>
        <?php endforeach; ?>
    </tbody>
</table>
</body>
</html>