require 'conexao.php';
if (!isset($_GET['id'])) {
    die("ID da nota não informado.");
}
$id = intval($_GET['id']);

$stmt = $pdo->prepare("SELECT n.*, c.nome AS cliente_nome, c.cpf_cnpj, c.endereco, s.nome AS servico_nome FROM notas_recebimento n JOIN clientes c ON c.id = n.cliente_id JOIN servicos s ON s.id = n.servico_id WHERE n.id = ?");
$stmt->execute([$id]);
$nota = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$nota) {
    die("Nota não encontrada.");
}
?>
<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <title>Recibo</title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css">
    <style>
        .recibo {
            max-width: 700px;
            margin: auto;
            padding: 30px;
            border: 1px solid #ccc;
            font-size: 16px;
        }
        @media print {
            .btn-print { display: none; }
        }
    </style>
</head>
<body>
<div class="recibo">
    <h4 class="text-center">RECIBO DE PAGAMENTO</h4>
    <hr>
    <p><strong>Cliente:</strong> <?= htmlspecialchars($nota['cliente_nome']) ?></p>
    <p><strong>CPF/CNPJ:</strong> <?= htmlspecialchars($nota['cpf_cnpj']) ?></p>
    <p><strong>Endereço:</strong> <?= htmlspecialchars($nota['endereco']) ?></p>
    <p><strong>Serviço:</strong> <?= htmlspecialchars($nota['servico_nome']) ?></p>
    <p><strong>Valor:</strong> R$ <?= number_format($nota['valor'], 2, ',', '.') ?></p>
    <p><strong>Vencimento:</strong> <?= date('d/m/Y', strtotime($nota['vencimento'])) ?></p>
    <p><strong>Forma de pagamento:</strong> <?= htmlspecialchars($nota['forma_pagamento']) ?></p>
    <p><strong>Chave PIX / Conta:</strong> <?= htmlspecialchars($nota['chave_pix']) ?></p>
    <p><strong>Observações:</strong> <?= nl2br(htmlspecialchars($nota['observacoes'])) ?></p>
    <hr>
    <p class="text-end">Emitido em: <?= date('d/m/Y H:i', strtotime($nota['data_emissao'])) ?></p>
    <div class="text-center mt-4">
        <button class="btn btn-primary btn-print" onclick="window.print()">Imprimir Recibo</button>
    </div>
</div>
</body>
</html>

<?php